var $ = jQuery = require('jquery');
var storage = require('electron-json-storage');
var swal = require('sweetalert');
var prompt = -1;
var admin = false;
var password = 'Kultur';
$(window).on('keyup', function(e) {
    var input = String.fromCharCode(e.keyCode).toLowerCase();
    var split = password.toLowerCase().split('');
    if (split[(prompt+1)] === input) {
        prompt++;
        if (prompt === split.length-1) {
            admin = !admin;
            oah.setAdmin();
            prompt = -1;
            oah.paint();
        }
    } else {
        prompt = -1;
    }
});

var oah = {
    key: 'oah.checkin',
    page: window.page || 'home',
    data: {},
    days: ['2018-06-01', '2018-06-02'],
    tickets: {},
    canvas: null,
    templates: {},
    updatePending: false,
    updateUrl: 'https://admin.oah.pascalwacker.ch/data',
    timeout: 15*1000,

    eventLoop: function() {
        if (oah.updatePending && navigator.onLine) {
            jQuery.post(oah.updateUrl, oah.data, function(result) {
                if (result && result.status) {
                    oah.updatePending = false;
                }
            }, 'json');
        }

        window.setTimeout(oah.eventLoop, oah.timeout);
    },

    setAdmin: function() {
        if (admin) {
            $('.admin-wrapper .admin-list > .navigation > span').text(password);
            $('.admin-wrapper').show();
        } else {
            $('.admin-wrapper').hide();
        }
    },

    getActiveDay: function() {
        var now = new Date();
        var month = now.getMonth() + 1;
        month = month < 10 ? '0' + month : month;
        var day = now.getDate();
        day = day < 10 ? '0' + day : day;
        var today = now.getFullYear() + '-' + month + '-' + day;

        if (oah.days.includes(today)) {
            return today;
        }

        return oah.days[0];
    },

    getReadableDate: function(date) {
        return date.split('-').reverse().join('.');
    },

    loadTemplates: function() {
        var pages = ['home', 'homeEntry', 'homeEntryAdd'];
        var loaded = 0;
        for (var i=0;i<pages.length;i++) {
            var curPage = pages[i];
            jQuery.get('pages/'+curPage+'.html', function(template) {
                var re = /pages\/([\w\-\._]+).html/g;
                var m = re.exec(this.url);
                var page = m.length > 1 ? m[1] : 'unknown';
                oah.templates[page] = template;
                loaded++;
                if (loaded == pages.length || oah.page == page) {
                    oah.paint();
                }
            });
        }
    },

    loadDefaults: function() {
        var types = ['U16', 'Normal', 'Stucard', 'Legi', 'Helfer', 'OK', 'Gästeliste', 'Gratis'];
        oah.data = {
            '2018-06-01': {
                'name': 'Freitag',
                'data': []
            },
            '2018-06-02': {
                'name': 'Samstag',
                'data': []
            },
            'all': {
                'name': 'Kombi',
                'data': []
            },
        }

        for (var key in oah.data) {
            if (typeof oah.data[key] === 'object' && typeof oah.data[key].data === 'object') {
                for (var i=0; i<types.length; i++) {
                    oah.data[key].data.push({
                        name: types[i],
                        count: 0,
                        custom: false,
                    });
                }
            }
        }
    },

    run: function() {
        oah.canvas = $('#canvas');
        oah.loadDefaults();
        oah.loadTemplates();

        storage.get(this.key, function(err, data) {
            if (err) { throw err; }

            if (typeof data === 'object') {
                var newData = oah.data;
                for (var key in data) {
                    if (typeof newData[key] === 'object' && typeof newData[key].data === 'object' && typeof data[key] === 'object' && typeof data[key].data === 'object') {
                        for (var i=0; i<data[key].data.length; i++) {
                            var curData = data[key].data[i];
                            var curEntryFound = false;
                            for (var j=0; j<newData[key].data.length; j++) {
                                if (newData[key].data[j].name === curData.name) {
                                    newData[key].data[j].count = curData.count;
                                    curEntryFound = true;
                                    break;
                                }
                            }
                            if (!curEntryFound) {
                                newData[key].data.push(curData);
                            }
                        }
                    }
                }
                oah.data = newData;
                oah.updatePending = true;
            }
            oah.paint();
        });

        oah.paint();
        $('.admin-wrapper .admin-list li > a').on('click', function(e) {
            e.preventDefault();

            if ($(this).hasClass('admin-delete-all')) {
                swal({
                    title: 'Alles löschen?',
                    text: "Das löschen kann nicht rückgängig gemacht werden!",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                })
                .then(function(willDelete) {
                    if (willDelete) {
                        for (var key in oah.data) {
                            if (typeof oah.data[key] === 'object' && typeof oah.data[key].data === 'object') {
                                for (var i=oah.data[key].data.length; i>=0; i--) {
                                    oah.deleteEntry(key, i);
                                }
                            }
                        }
                        oah.paint();
                        oah.save();
                        
                        swal('Poof! Alles ist gelöscht!', {
                            icon: "success",
                        });
                    }
                });
            }
        });

        oah.eventLoop();
    },

    deleteEntry: function(key, index, paintAndSave) {
        paintAndSave = paintAndSave || false;
        if (typeof oah.data[key] === 'object' && typeof oah.data[key].data === 'object' && oah.data[key].data.length > 0 && typeof oah.data[key].data[index] === 'object') {
            if (!oah.data[key].data[index].custom) {
                oah.setCount(key, oah.data[key].data[index].name, 0);
            } else {
                oah.data[key].data.splice(index, 1);
            }

            if (paintAndSave) {
                oah.paint();
                oah.save();
            }
        }
    },

    save: function() {
        storage.set(oah.key, oah.data, function(err) {
            if (err) { throw err; }
        });
        oah.updatePending = true;
        oah.paint();
    },

    paint: function() {
        if (typeof oah[oah.page].paint === 'function') {
            oah[oah.page].paint();
        }
        if (typeof oah[oah.page].init === 'function') {
            oah[oah.page].init();
        }
        oah.canvas.find('a[data-link]').on('click', function(e) {
            e.preventDefault();

            oah.page = $(this).data('link');
            oah.paint();
        });

        oah.setAdmin();
    },

    template: function(page, data) {
        page = page || oah.page;
        data = data || oah.data;
        if (typeof oah.templates === 'object' && typeof oah.templates[page] === 'string' && oah.templates[page] !== '') {
            var re = /{{ ([\w\-\._]+) }}/gm;
            var m;
            var template = oah.templates[page];
            do {
                m = re.exec(template);
                if (m) {
                    if (typeof m[1] === 'string' && m[1] !== '') {
                        var varName = m[1];
                        var varValue = m[1];
                        var testVar = oah.getValue(varName, data);
                        if (testVar || typeof testVar === 'number') {
                            varValue = testVar;
                        }
                        
                        template = template.replace('{{ ' + varName + ' }}', varValue);
                    }
                }
            } while (m);

            return template;
        }

        return false;
    },

    getValue: function(key, data) {
        var split = key.split('.');
        if (split.length === 0 || (split.length === 1 && split[0] === '')) {
            return;
        }

        if (split.length == 1) {
            if (typeof data[key] === 'string' || typeof data[key] === 'number') {
                return data[key];
            }
            return;
        } else {
            var key = split.shift();
            if (typeof data[key] === 'object') {
                return oah.getValue(split.join('.'), data[key]);
            }
            return;
        }
    },

    getCount: function(key, name) {
        var count = 0;
        if (typeof oah.data[key] === 'object' && typeof oah.data[key].data === 'object' && oah.data[key].data.length > 0) {
            for (var i=0;i<oah.data[key].data.length;i++) {
                if (typeof oah.data[key].data[i].name === 'string' && oah.data[key].data[i].name === name && typeof oah.data[key].data[i].count === 'number') {
                    count = oah.data[key].data[i].count;
                    break;
                }
            }
        }

        return count;
    },

    setCount: function(key, name, count, custom) {
        custom = custom || false;
        if (typeof oah.data[key] === 'object' && typeof oah.data[key].data === 'object' && oah.data[key].data.length >= 0) {
            var found = false;
            for (var i=0;i<oah.data[key].data.length;i++) {
                if (typeof oah.data[key].data[i].name === 'string' && oah.data[key].data[i].name === name && typeof oah.data[key].data[i].count !== 'undefined') {
                    if (custom) {
                        count++;
                    }
                    oah.data[key].data[i].count = count;
                    found = true;
                    break;
                }
            }
            if (!found) {
                oah.data[key].data.push({
                    name: name,
                    count: count,
                    custom: custom,
                })
            }
        }
    },

    init: function() {
        oah.canvas.find('.tabs > li[data-target]').on('click', function(e) {
            e.preventDefault();
            var $this = $(this);
            var tabs = $this.closest('.tabs');
            var target = $this.data('target');
            var canvas = oah.canvas.find(tabs.data('tabs-target'));
            if (oah.home.currentTab !== target) {
                tabs.find('> li[data-target].active').removeClass('active');
                $this.addClass('active');
                canvas.find('> .tabs-target').hide();
                canvas.find('> .tabs-target[data-tab="' + target + '"]').show();
            }

            if (tabs.attr('id') === 'home-day-tabs') {
                oah.home.currentTab = target;
            }
        });

        oah.canvas.find('.tabs').each(function() {
            var $this = jQuery(this);
            var tabs = $this.find('> li[data-target]').length;
            var width = Math.floor(100/tabs);
            var last = 100-((tabs-1)*width);
            $this.find('> li[data-target]').css('width', width+'%');
            $this.find('> li[data-target]:last').css('width', last+'%');
        });
    },

    home: {
        currentTab: '',

        init: function() {
            oah.init();

            oah.canvas.find('#home-day-tabs-canvas .home-tab-entry-wrapper .home-tab-entry-inner-wrapper > .home-tab-entry.home-tab-entry-add').on('click', function(e) {
                e.preventDefault();

                var $this = $(this);
                var key = $this.data('key');
                swal({
                    title: "Neue Kategorie erfassen",
                    text: "Bitte Namen eingeben",
                    buttons: ["Abbrechen", "Erfassen"],
                    content: "input"
                }).then(function(value) {
                    if (typeof value === 'number' || (typeof value === 'string' && value !== '')) {
                        var count = oah.getCount(key, value);
                        oah.setCount(key, value, count, true);

                        oah.paint();
                        oah.save();
                    }
                });
            });

            oah.canvas.find('#home-day-tabs-canvas .home-tab-entry-wrapper .home-tab-entry-inner-wrapper > .home-tab-entry > .home-tab-entry-delete').on('click', function(e) {
                e.preventDefault();
                $that = $(this);
                var $this = $that.closest('.home-tab-entry');
                var title = $this.data('name');
                var key = $this.data('key');
                var index = -1;
                if (typeof oah.data[key] === 'object' && typeof oah.data[key].data === 'object') {
                    for (var i=0; i<oah.data[key].data.length; i++) {
                        if (oah.data[key].data[i].name === title) {
                            index = i;
                            break;
                        }
                    }
                }

                if (index > -1) {
                    swal({
                        title: title + ' löschen?',
                        text: "Das löschen kann nicht rückgängig gemacht werden!",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then(function(willDelete) {
                        if (willDelete) {
                            oah.deleteEntry(key, index, true);
                            
                            swal('Poof! ' + title + ' ist gelöscht!', {
                                icon: "success",
                            });
                        }
                    });
                }
            });

            oah.canvas.find('#home-day-tabs-canvas .home-tab-entry-wrapper .home-tab-entry-inner-wrapper > .home-tab-entry .home-tab-entry-modifyer').on('click', function(e) {
                e.preventDefault();
                var $that = $(this);
                var $this = $that.closest('.home-tab-entry');
                var key = $this.data('key');
                if ($this.hasClass('home-tab-entry-add')) {
                    swal({
                        title: "Neue Kategorie erfassen",
                        text: "Bitte Namen eingeben",
                        buttons: ["Abbrechen", "Erfassen"],
                        content: "input"
                    }).then(function(value) {
                        if (typeof value === 'number' || (typeof value === 'string' && value !== '')) {
                            var count = oah.getCount(key, value);
                            oah.setCount(key, value, count, true);

                            oah.paint();
                            oah.save();
                        }
                    });
                } else {
                    var name = $this.data('name');
                    var count = oah.getCount(key, name);
                    if ($that.hasClass('home-tab-entry-modifyer-minus')) {
                        if (count > 0) {
                            count--;
                        }
                    } else {
                        count ++;
                    }
                    oah.setCount(key, name, count);

                    oah.paint();
                    oah.save();
                }
            });
        },

        paint: function() {
            if (oah.page === 'home' && typeof oah.canvas === 'object' && oah.template()) {
                oah.canvas.html(oah.template());
                var tabs = oah.canvas.find('#home-day-tabs');
                var content = oah.canvas.find('#home-day-tabs-canvas');
                var active = oah.home.currentTab !== '' ? oah.home.currentTab : oah.getActiveDay();
                oah.home.currentTab = active;
                for (var i=0; i<oah.days.length; i++) {
                    var key = oah.days[i];
                    var day = '';
                    if (typeof oah.data[key] === 'object' && typeof oah.data[key].name === 'string') {
                        day = oah.data[key].name;
                    } else {
                        day = oah.getReadableDate(key);
                    }
                    tabs.append('<li data-target="' + key + '"' + (key === active ? ' class="active"' : '') + '>'+ day +'</li>');
                    var tab = $('<div class="tabs-target" data-tab="' + key + '"' + (key === active ? ' style="display: block;"' : '') + '></div>');
                    
                    var count = 0;
                    if (typeof oah.data[key] === 'object' && typeof oah.data[key].data === 'object' && typeof oah.data[key].name === 'string') {
                        count += oah.home.paintEntry(tab, oah.data[key].name, oah.data[key].data, key);
                    }
                    if (typeof oah.data['all'] === 'object' && typeof oah.data['all'].data === 'object' && typeof oah.data['all'].name === 'string') {
                        count += oah.home.paintEntry(tab, oah.data['all'].name, oah.data['all'].data);
                    }
                    if (typeof oah.data[key] === 'object' && typeof oah.data[key].data === 'object' && typeof oah.data[key].name === 'string') {
                        count += oah.home.paintEntry(tab, 'Sonstiges: ' + oah.data[key].name, oah.data[key].data, key, true);
                    }
                    if (typeof oah.data['all'] === 'object' && typeof oah.data['all'].data === 'object' && typeof oah.data['all'].name === 'string') {
                        count += oah.home.paintEntry(tab, 'Sonstiges: ' + oah.data['all'].name, oah.data['all'].data, 'all', true);
                    }
                    tab.prepend('<h2 class="oah-platz-count-wrapper">Auf Platz ' + day + ': <span class="oah-platz-count">' + count + '</span>');

                    content.append(tab);
                }
            }
        },

        paintEntry: function(wrapper, name, data, key, custom) {
            key = key || 'all';
            custom = custom || false;
            var count = 0;
            var people = 0;

            var entryWrapper = $('<div class="home-tab-entry-wrapper"></div>');
            entryWrapper.append('<div class="home-tab-entry-title">' + name + '</div>');
            var innerWrapper = $('<div class="home-tab-entry-inner-wrapper"></div>');
            for (var j=0; j<data.length; j++) {
                var curData = data[j];
                if (curData.custom === custom) {
                    curData.key = key;
                    var entryTemplate = oah.template('homeEntry', curData);
                    if (entryTemplate) {
                        entryTemplate = jQuery(entryTemplate);
                        if (curData.custom || admin) {
                            entryTemplate.append('<a href="#" class="home-tab-entry-delete">X</a>');
                        }
                        innerWrapper.append(entryTemplate);
                        count++;
                        people += curData.count;
                    }
                }
            }
            if (!custom) {
                var entryTemplate = oah.template('homeEntryAdd', {key: key});
                if (entryTemplate) {
                    innerWrapper.append(entryTemplate);
                    count++;
                }
            }
            entryWrapper.append(innerWrapper);

            if (count > 0) {
                wrapper.append(entryWrapper);
            }

            return people;
        },

        increment: function(e) {
            e.preventDefault();
            oah.data.count++;
            oah.save();
        }
    }
};
oah.run();